<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Property;
use App\Models\BlogPost;
use App\Models\Testimonial;
use Illuminate\Http\Request;

class AnalyticsController extends Controller
{
    public function index()
    {
        $totalViews = Property::sum('views_count');
        $totalProperties = Property::count();
        $activeProperties = Property::where('status', 'available')->count();
        $featuredProperties = Property::where('is_featured', true)->count();

        $totalBlogPosts = BlogPost::count();
        $publishedBlogPosts = BlogPost::where('published', true)->count();
        $featuredBlogPosts = BlogPost::where('is_featured', true)->count();

        $totalTestimonials = Testimonial::count();
        $featuredTestimonials = Testimonial::where('is_featured', true)->count();

        return response()->json([
            'views' => [
                'total' => $totalViews,
                'thisMonth' => $totalViews, // Simplified for now
                'growth' => 0 // Simplified for now
            ],
            'properties' => [
                'total' => $totalProperties,
                'active' => $activeProperties,
                'featured' => $featuredProperties
            ],
            'blogPosts' => [
                'total' => $totalBlogPosts,
                'published' => $publishedBlogPosts,
                'featured' => $featuredBlogPosts
            ],
            'testimonials' => [
                'total' => $totalTestimonials,
                'featured' => $featuredTestimonials
            ],
            'inquiries' => [
                'total' => 0, // Placeholder
                'thisMonth' => 0,
                'pending' => 0
            ],
            'revenue' => [
                'total' => 0, // Placeholder
                'thisMonth' => 0,
                'growth' => 0
            ]
        ]);
    }
}
