<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\SectionSetting;
use Illuminate\Http\Request;

class SectionSettingsController extends Controller
{
    public function index()
    {
        $settings = SectionSetting::all()->pluck('settings', 'section_key');
        return response()->json(['data' => $settings]);
    }

    public function update(Request $request, string $section)
    {
        $validated = $request->validate([
            'title' => 'nullable|string',
            'subtitle' => 'nullable|string',
            'updated_at' => 'nullable|date'
        ]);

        $setting = SectionSetting::firstOrCreate(
            ['section_key' => $section],
            ['settings' => $validated]
        );

        $setting->update(['settings' => $validated]);

        return response()->json(['data' => $setting->settings]);
    }
}
