<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Apartment extends Model
{
    protected $fillable = [
        'name',
        'description',
        'area',
        'price',
        'bedrooms',
        'bathrooms',
        'category',
        'location',
        'amenities',
        'image',
        'gallery',
        'floor_plan',
        'is_featured',
        'status'
    ];

    protected $casts = [
        'amenities' => 'array',
        'gallery' => 'array',
        'is_featured' => 'boolean',
        'bedrooms' => 'integer',
        'bathrooms' => 'integer'
    ];
}
