<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Property extends Model
{
    protected $fillable = [
        'title',
        'description',
        'price',
        'location',
        'image',
        'gallery',
        'floor_plan',
        'status',
        'is_featured',
        'views_count'
    ];

    protected $casts = [
        'gallery' => 'array',
        'price' => 'decimal:2',
        'is_featured' => 'boolean',
        'views_count' => 'integer'
    ];
}
