<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('apartments', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description');
            $table->string('area');
            $table->string('price');
            $table->integer('bedrooms');
            $table->integer('bathrooms');
            $table->string('category');
            $table->string('location');
            $table->json('amenities');
            $table->string('image');
            $table->json('gallery')->nullable();
            $table->string('floor_plan')->nullable();
            $table->boolean('is_featured')->default(false);
            $table->enum('status', ['available', 'sold', 'rented'])->default('available');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('apartments');
    }
};
