<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            // Rename columns to match new structure
            $table->renameColumn('name', 'customer_name');
            $table->renameColumn('email', 'customer_email');
            $table->renameColumn('phone', 'customer_phone');
            $table->renameColumn('visit_date', 'check_in_date');
            $table->dropColumn('visit_time');
            $table->dropColumn('message');

            // Add new columns
            $table->foreignId('property_id')->nullable()->constrained()->onDelete('set null');
            $table->date('check_out_date')->nullable();
            $table->integer('guests_count')->nullable();
            $table->text('special_requests')->nullable();
            $table->enum('status', ['pending', 'confirmed', 'cancelled', 'completed'])->default('pending');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            // Reverse the changes
            $table->dropForeign(['property_id']);
            $table->dropColumn(['property_id', 'check_out_date', 'guests_count', 'special_requests', 'status']);

            // Rename back
            $table->renameColumn('customer_name', 'name');
            $table->renameColumn('customer_email', 'email');
            $table->renameColumn('customer_phone', 'phone');
            $table->renameColumn('check_in_date', 'visit_date');

            // Add back old columns
            $table->string('visit_time', 50)->nullable();
            $table->text('message');
        });
    }
};
