<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Apartments - NYINIMU Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <div class="bg-white w-64 shadow-lg">
            <div class="p-6">
                <h1 class="text-2xl font-bold text-[#81be01]">NYINIMU</h1>
                <p class="text-sm text-gray-600">Admin Dashboard</p>
            </div>
            <nav class="mt-6">
                <a href="{{ route('dashboard') }}" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5a2 2 0 012-2h4a2 2 0 012 2v2H8V5z"></path>
                    </svg>
                    Dashboard
                </a>
                <a href="{{ route('dashboard.properties') }}" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                    Properties
                </a>
                <div class="px-6">
                    <button type="button" onclick="toggleNav('nav-props-sub')" class="text-xs text-gray-600 hover:text-gray-900">Show options</button>
                    <div id="nav-props-sub" class="ml-6 mt-2 space-y-1 hidden">
                        <a href="{{ route('dashboard.properties') }}#create" class="block text-sm text-gray-700 hover:underline">Add New</a>
                        <a href="{{ route('dashboard.properties') }}#categories" class="block text-sm text-gray-700 hover:underline">Categories</a>
                        <a href="{{ route('dashboard.properties') }}#category-create" class="block text-sm text-gray-700 hover:underline">Create New Category</a>
                    </div>
                </div>
                <a href="{{ route('dashboard.blogs') }}" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                    </svg>
                    Blog Posts
                </a>
                <div class="px-6">
                    <button type="button" onclick="toggleNav('nav-blogs-sub')" class="text-xs text-gray-600 hover:text-gray-900">Show options</button>
                    <div id="nav-blogs-sub" class="ml-6 mt-2 space-y-1 hidden">
                        <a href="{{ route('dashboard.blogs') }}#create" class="block text-sm text-gray-700 hover:underline">Add New</a>
                        <a href="{{ route('dashboard.blogs') }}#categories" class="block text-sm text-gray-700 hover:underline">Categories</a>
                        <a href="{{ route('dashboard.blogs') }}#category-create" class="block text-sm text-gray-700 hover:underline">Create New Category</a>
                    </div>
                </div>
                <a href="{{ route('dashboard.testimonials') }}" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                    </svg>
                    Testimonials
                </a>
                <a href="{{ route('dashboard.hero-slides') }}" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    Hero Slides
                </a>
                <a href="{{ route('dashboard.apartments') }}" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200 bg-blue-50 text-[#81be01] border-r-4 border-blue-600">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                    </svg>
                    Apartments
                </a>
                <form method="POST" action="{{ route('logout') }}" class="px-6 py-3">
                    @csrf
                    <button type="submit" class="flex items-center gap-3 w-full text-left text-red-600 hover:text-red-800 transition-colors duration-200">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                        </svg>
                        Logout
                    </button>
                </form>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 p-8">
            <div class="mb-8">
                <h2 class="text-3xl font-bold text-[#81be01]">Manage Apartments</h2>
                <p class="text-gray-600 mt-2">View and manage apartment listings.</p>
            </div>

            <!-- Create Apartment Form -->
            <div id="create-apartment-form" class="bg-white p-8 rounded-xl shadow-xl mb-8 hidden border border-gray-100">
                <div class="flex items-center gap-3 mb-6">
                    <div class="w-10 h-10 bg-gradient-to-br from-red-500 to-red-600 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-2xl font-bold text-[#81be01]">Create New Apartment</h3>
                        <p class="text-gray-600">Add a new apartment listing to your portfolio</p>
                    </div>
                </div>
                <form id="apartmentForm" class="space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Name</label>
                            <input type="text" name="name" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Location</label>
                            <input type="text" name="location" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Price</label>
                            <input type="number" name="price" step="0.01" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Area (sq ft)</label>
                            <input type="number" name="area" step="0.01" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Bedrooms</label>
                            <input type="number" name="bedrooms" min="0" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Bathrooms</label>
                            <input type="number" name="bathrooms" min="0" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Category</label>
                            <input type="text" name="category" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Status</label>
                            <select name="status" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                                <option value="available">Available</option>
                                <option value="rented">Rented</option>
                                <option value="maintenance">Maintenance</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Image</label>
                            <input type="file" name="image" accept="image/*" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"><div class="mt-2"><img id="apartment-image-preview" alt="Image preview" class="hidden w-full h-40 object-cover rounded-md border border-gray-200" /></div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Floor Plan</label>
                            <input type="file" name="floor_plan" accept="image/*" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"><div class="mt-2"><img id="apartment-floor-plan-preview" alt="Floor plan preview" class="hidden w-full h-40 object-cover rounded-md border border-gray-200" /></div>
                        </div>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700">Description</label>
                        <textarea name="description" rows="3" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"></textarea>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Amenities (comma-separated)</label>
                        <input type="text" name="amenities" placeholder="WiFi, Parking, Gym, etc." class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                    </div>
                      <div class="flex items-center">
                        <input type="hidden" name="is_featured" value="0">
                        <label class="inline-flex items-center cursor-pointer select-none">
                          <input type="checkbox" name="is_featured" value="1" class="sr-only peer">
                          <div class="relative w-11 h-6 bg-gray-200 rounded-full transition-colors peer-focus:outline-none peer-checked:bg-[#81be01]">
                            <span class="absolute top-0.5 left-0.5 h-5 w-5 bg-white rounded-full shadow transition-transform peer-checked:translate-x-5"></span>
                          </div>
                          <span class="ml-2 text-sm text-gray-900">Featured Apartment</span>
                        </label>
                      </div>
                    <div class="flex justify-end space-x-3 pt-6 border-t border-gray-100">
                        <button type="button" onclick="hideApartmentForm()" class="bg-gray-500 text-white px-6 py-3 rounded-lg hover:bg-gray-600 transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg">Cancel</button>
                        <button type="submit" class="bg-gradient-to-r from-red-500 to-red-600 text-white px-6 py-3 rounded-lg hover:from-red-600 hover:to-red-700 transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg flex items-center gap-2">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            Create Apartment
                        </button>
                    </div>
                </form>
            </div>

            <div class="bg-white p-6 rounded-xl shadow-lg">
                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
                    <div>
                        <h3 class="text-2xl font-bold text-[#81be01]">Apartments List</h3>
                        <p class="text-gray-600 mt-1">Manage apartment listings</p>
                    </div>
                    <button onclick="showApartmentForm()" class="bg-gradient-to-r from-red-500 to-red-600 text-white px-6 py-3 rounded-lg hover:from-red-600 hover:to-red-700 transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-xl flex items-center gap-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Add New Apartment
                    </button>
                </div>
                <div id="apartments-list" class="overflow-x-auto">
                    <!-- Apartments will be loaded here -->
                </div>
            </div>
        </div>
    </div>

    <script>
        function showApartmentForm() {
            document.getElementById('create-apartment-form').classList.remove('hidden');
        }

        function hideApartmentForm() {
            document.getElementById('create-apartment-form').classList.add('hidden');
            document.getElementById('apartmentForm').reset();
        }

async function createApartment(formData) {
            try {
                const response = await fetch('/api/apartments', {
                    method: 'POST',
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    },
                    body: formData
                });

                if (response.ok) {
                    hideApartmentForm();
                    loadApartments();
                    alert('Apartment created successfully!');
                } else {
                    const error = await response.json();
                    alert('Error creating apartment: ' + (error.message || 'Unknown error'));
                }
            } catch (error) {
                console.error('Failed to create apartment:', error);
                alert('Error creating apartment');
            }
        }

        async function loadApartments() {
            try {
                const response = await fetch('/api/apartments', {
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    }
                });
                const data = await response.json();
                const list = document.getElementById('apartments-list');
                if (data.data && data.data.length > 0) {
                    list.innerHTML = '<table class="w-full table-auto"><thead><tr><th class="px-4 py-2">Name</th><th class="px-4 py-2">Location</th><th class="px-4 py-2">Price</th><th class="px-4 py-2">Bedrooms</th><th class="px-4 py-2">Status</th><th class="px-4 py-2">Actions</th></tr></thead><tbody>' +
                        data.data.map(apartment => `<tr>
                            <td class="border px-4 py-2">
                                <div class="flex items-center gap-3">
                                    ${apartment.image ? `<img src="${apartment.image}" alt="${apartment.name}" class="w-16 h-10 object-cover rounded border" />` : ''}
                                    <span>${apartment.name}</span>
                                </div>
                            </td>
                            <td class="border px-4 py-2">${apartment.location}</td>
                            <td class="border px-4 py-2">UGX ${apartment.price}</td>
                            <td class="border px-4 py-2">${apartment.bedrooms || 0}</td>
                            <td class="border px-4 py-2">${apartment.status}</td>
                            <td class="border px-4 py-2">
                                <button onclick="editApartment(${apartment.id})" class="bg-[#81be01] text-white px-3 py-1.5 rounded text-sm hover:bg-[#6da001] transition-colors duration-200 mr-2">Edit</button>
                                <button onclick="deleteApartment(${apartment.id})" class="bg-red-500 text-white px-3 py-1.5 rounded text-sm hover:bg-red-600 transition-colors duration-200">Delete</button>
                            </td>
                        </tr>`).join('') +
                        '</tbody></table>';
                } else {
                    list.innerHTML = '<p>No apartments found.</p>';
                }
            } catch (error) {
                console.error('Failed to load apartments:', error);
                document.getElementById('apartments-list').innerHTML = '<p>Error loading apartments.</p>';
            }
        }

        document.getElementById('apartmentForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(e.target);
            // Normalize boolean and arrays for PHP
            formData.set('is_featured', e.target.is_featured.checked ? '1' : '0');
            const amenities = formData.get('amenities');
            if (amenities) {
                // Clear raw field and append as array
                formData.delete('amenities');
                amenities.split(',').map(s => s.trim()).filter(Boolean).forEach(val => {
                    formData.append('amenities[]', val);
                });
            }
            const mode = e.target.getAttribute('data-mode');
            const id = e.target.getAttribute('data-id');
            if (mode === 'edit' && id) {
                updateApartment(id, formData);
            } else {
                createApartment(formData);
            }
        });

        async function editApartment(id) {
            try {
                const response = await fetch(`/api/apartments/${id}`, {
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    }
                });
                const payload = await response.json();
                const apartment = payload.data || payload;
                const form = document.getElementById('apartmentForm');
                form.name.value = apartment.name || '';
                form.location.value = apartment.location || '';
                form.price.value = apartment.price || '';
                form.area.value = apartment.area || '';
                form.bedrooms.value = apartment.bedrooms || 0;
                form.bathrooms.value = apartment.bathrooms || 0;
                form.category.value = apartment.category || '';
                form.amenities.value = Array.isArray(apartment.amenities) ? apartment.amenities.join(', ') : (apartment.amenities || '');
                form.is_featured.checked = !!apartment.is_featured;
                // Previews and optional files on edit
                const imgPrev = document.getElementById('apartment-image-preview');
                const fpPrev = document.getElementById('apartment-floor-plan-preview');
                if (imgPrev && apartment.image) { imgPrev.src = apartment.image; imgPrev.classList.remove('hidden'); }
                if (fpPrev && apartment.floor_plan) { fpPrev.src = apartment.floor_plan; fpPrev.classList.remove('hidden'); }
                const imgInput = form.querySelector('input[name="image"]'); if (imgInput) imgInput.removeAttribute('required');
                // Switch to edit mode
                form.setAttribute('data-mode', 'edit');
                form.setAttribute('data-id', id);
                document.querySelector('#apartmentForm button[type="submit"]').textContent = 'Update Apartment';
                // Show form if hidden
                if (typeof showApartmentForm === 'function') { showApartmentForm(); }
            } catch (err) {
                console.error('Failed to load apartment:', err);
                alert('Failed to load apartment for editing');
            }
        }

        async function deleteApartment(id) {
            if (!confirm('Are you sure you want to delete this apartment?')) return;
            try {
                const response = await fetch(`/api/apartments/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    }
                });
                if (response.ok) {
                    loadApartments();
                    alert('Apartment deleted successfully!');
                } else {
                    const error = await response.json();
                    alert('Error deleting apartment: ' + (error.message || 'Unknown error'));
                }
            } catch (err) {
                console.error('Failed to delete apartment:', err);
                alert('Error deleting apartment');
            }
        }

        loadApartments();
        // Apartment image previews
        (function(){
            const form = document.getElementById('apartmentForm');
            if (!form) return;
            const imgInput = form.querySelector('input[name="image"]');
            const floorInput = form.querySelector('input[name="floor_plan"]');
            const setPreview = (input, id) => {
                input?.addEventListener('change', (e) => {
                    const file = e.target.files && e.target.files[0];
                    const img = document.getElementById(id);
                    if (file && img) { img.src = URL.createObjectURL(file); img.classList.remove('hidden'); }
                });
            };
            setPreview(imgInput, 'apartment-image-preview');
            setPreview(floorInput, 'apartment-floor-plan-preview');
        })();
</script>
<script>
    function toggleNav(id){ var el=document.getElementById(id); if(el){ el.classList.toggle('hidden'); } }
</script>
</body>
</html>


