<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Testimonials - NYINIMU Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <div class="bg-white w-64 shadow-lg">
            <div class="p-6">
                <h1 class="text-2xl font-bold text-[#81be01]">NYINIMU</h1>
                <p class="text-sm text-gray-600">Admin Dashboard</p>
            </div>
            <nav class="mt-6">
                <a href="{{ route('dashboard') }}" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5a2 2 0 012-2h4a2 2 0 012 2v2H8V5z"></path>
                    </svg>
                    Dashboard
                </a>
                <a href="{{ route('dashboard.properties') }}" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                    Properties
                </a>
                <div class="px-6">
                    <button type="button" onclick="toggleNav('nav-props-sub')" class="text-xs text-gray-600 hover:text-gray-900">Show options</button>
                    <div id="nav-props-sub" class="ml-6 mt-2 space-y-1 hidden">
                        <a href="{{ route('dashboard.properties') }}#create" class="block text-sm text-gray-700 hover:underline">Add New</a>
                        <a href="{{ route('dashboard.properties') }}#categories" class="block text-sm text-gray-700 hover:underline">Categories</a>
                        <a href="{{ route('dashboard.properties') }}#category-create" class="block text-sm text-gray-700 hover:underline">Create New Category</a>
                    </div>
                </div>
                <a href="{{ route('dashboard.blogs') }}" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                    </svg>
                    Blog Posts
                </a>
                <div class="px-6">
                    <button type="button" onclick="toggleNav('nav-blogs-sub')" class="text-xs text-gray-600 hover:text-gray-900">Show options</button>
                    <div id="nav-blogs-sub" class="ml-6 mt-2 space-y-1 hidden">
                        <a href="{{ route('dashboard.blogs') }}#create" class="block text-sm text-gray-700 hover:underline">Add New</a>
                        <a href="{{ route('dashboard.blogs') }}#categories" class="block text-sm text-gray-700 hover:underline">Categories</a>
                        <a href="{{ route('dashboard.blogs') }}#category-create" class="block text-sm text-gray-700 hover:underline">Create New Category</a>
                    </div>
                </div>
                <a href="{{ route('dashboard.testimonials') }}" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200 bg-blue-50 text-[#81be01] border-r-4 border-blue-600">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                    </svg>
                    Testimonials
                </a>
                <a href="{{ route('dashboard.hero-slides') }}" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    Hero Slides
                </a>
                <a href="{{ route('dashboard.apartments') }}" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                    </svg>
                    Apartments
                </a>
                <form method="POST" action="{{ route('logout') }}" class="px-6 py-3">
                    @csrf
                    <button type="submit" class="flex items-center gap-3 w-full text-left text-red-600 hover:text-red-800 transition-colors duration-200">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                        </svg>
                        Logout
                    </button>
                </form>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 p-8">
            <div class="mb-8">
                <h2 class="text-3xl font-bold text-[#81be01]">Manage Testimonials</h2>
                <p class="text-gray-600 mt-2">View and manage customer testimonials.</p>
            </div>

            <!-- Create Testimonial Form -->
            <div id="create-testimonial-form" class="bg-white p-8 rounded-xl shadow-xl mb-8 hidden border border-gray-100">
                <div class="flex items-center gap-3 mb-6">
                    <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-2xl font-bold text-[#81be01]">Create New Testimonial</h3>
                        <p class="text-gray-600">Add customer reviews and feedback</p>
                    </div>
                </div>
                <form id="testimonialForm" class="space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Name</label>
                            <input type="text" name="name" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Role</label>
                            <input type="text" name="role" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Image</label>
                            <input type="file" name="image" accept="image/*" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700">Quote</label>
                        <textarea name="quote" rows="4" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"></textarea>
                    </div>
                    <div class="flex items-center">
                        <input type="hidden" name="is_featured" value="0">
                        <input type="checkbox" name="is_featured" value="1" class="h-4 w-4 text-[#81be01] focus:ring-blue-500 border-gray-300 rounded">
                        <label class="ml-2 block text-sm text-gray-900">Featured Testimonial</label>
                    </div>
                    <div class="flex justify-end space-x-3 pt-6 border-t border-gray-100">
                        <button type="button" onclick="hideTestimonialForm()" class="bg-gray-500 text-white px-6 py-3 rounded-lg hover:bg-gray-600 transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg">Cancel</button>
                        <button type="submit" class="bg-gradient-to-r from-purple-500 to-purple-600 text-white px-6 py-3 rounded-lg hover:from-purple-600 hover:to-purple-700 transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg flex items-center gap-2">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            Create Testimonial
                        </button>
                    </div>
                </form>
            </div>

            <div class="bg-white p-6 rounded-xl shadow-lg">
                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
                    <div>
                        <h3 class="text-2xl font-bold text-[#81be01]">Testimonials List</h3>
                        <p class="text-gray-600 mt-1">Manage customer reviews and feedback</p>
                    </div>
                    <button onclick="showTestimonialForm()" class="bg-gradient-to-r from-purple-500 to-purple-600 text-white px-6 py-3 rounded-lg hover:from-purple-600 hover:to-purple-700 transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-xl flex items-center gap-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Add New Testimonial
                    </button>
                </div>
                <div id="testimonials-list" class="overflow-x-auto">
                    <!-- Testimonials will be loaded here -->
                </div>
            </div>
        </div>
    </div>

    <script>
        function showTestimonialForm() {
            document.getElementById('create-testimonial-form').classList.remove('hidden');
        }

        function hideTestimonialForm() {
            document.getElementById('create-testimonial-form').classList.add('hidden');
            document.getElementById('testimonialForm').reset();
            document.getElementById('testimonialForm').removeAttribute('data-mode');
            document.getElementById('testimonialForm').removeAttribute('data-id');
            document.querySelector('#testimonialForm button[type="submit"]').textContent = 'Create Testimonial';
        }

        async function createTestimonial(formData) {
            try {
                const response = await fetch('/api/testimonials', {
                    method: 'POST',
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    },
                    body: formData
                });

                if (response.ok) {
                    hideTestimonialForm();
                    loadTestimonials();
                    alert('Testimonial created successfully!');
                } else {
                    const error = await response.json();
                    alert('Error creating testimonial: ' + (error.message || 'Unknown error'));
                }
            } catch (error) {
                console.error('Failed to create testimonial:', error);
                alert('Error creating testimonial');
            }
        }

        async function updateTestimonial(id, formData) {
            try {
                const response = await fetch(`/api/testimonials/${id}`, {
                    method: 'PUT',
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    },
                    body: formData
                });

                if (response.ok) {
                    hideTestimonialForm();
                    loadTestimonials();
                    alert('Testimonial updated successfully!');
                } else {
                    const error = await response.json();
                    alert('Error updating testimonial: ' + (error.message || 'Unknown error'));
                }
            } catch (error) {
                console.error('Failed to update testimonial:', error);
                alert('Error updating testimonial');
            }
        }

        async function loadTestimonials() {
            try {
                const response = await fetch('/api/testimonials', {
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    }
                });
                const data = await response.json();
                const list = document.getElementById('testimonials-list');
                if (data.data && data.data.length > 0) {
                    list.innerHTML = '<table class="w-full table-auto"><thead><tr><th class="px-4 py-2">Name</th><th class="px-4 py-2">Role</th><th class="px-4 py-2">Featured</th><th class="px-4 py-2">Actions</th></tr></thead><tbody>' +
                        data.data.map(testimonial => `<tr><td class="border px-4 py-2">${testimonial.name}</td><td class="border px-4 py-2">${testimonial.role || ''}</td><td class="border px-4 py-2">${testimonial.is_featured ? 'Yes' : 'No'}</td><td class="border px-4 py-2"><button onclick="editTestimonial(${testimonial.id})" class="bg-[#81be01] text-white px-3 py-1.5 rounded text-sm hover:bg-[#6da001] transition-colors duration-200 mr-2">Edit</button><button onclick="deleteTestimonial(${testimonial.id})" class="bg-red-500 text-white px-3 py-1.5 rounded text-sm hover:bg-red-600 transition-colors duration-200">Delete</button></td></tr>`).join('') +
                        '</tbody></table>';
                } else {
                    list.innerHTML = '<p>No testimonials found.</p>';
                }
            } catch (error) {
                console.error('Failed to load testimonials:', error);
                document.getElementById('testimonials-list').innerHTML = '<p>Error loading testimonials.</p>';
            }
        }

        document.getElementById('testimonialForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(e.target);

            const mode = e.target.getAttribute('data-mode');
            const id = e.target.getAttribute('data-id');

            if (mode === 'edit' && id) {
                updateTestimonial(id, formData);
            } else {
                createTestimonial(formData);
            }
        });

        async function editTestimonial(id) {
            try {
                const response = await fetch(`/api/testimonials/${id}`, {
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    }
                });
                const data = await response.json();
                if (data.success && data.data) {
                    const testimonial = data.data;
                    // Populate form with existing data
                    document.getElementById('testimonialForm').name.value = testimonial.name;
                    document.getElementById('testimonialForm').role.value = testimonial.role || '';
                    document.getElementById('testimonialForm').quote.value = testimonial.quote;
                    document.getElementById('testimonialForm').is_featured.checked = testimonial.is_featured;
                    // Change form to update mode
                    document.getElementById('testimonialForm').setAttribute('data-mode', 'edit');
                    document.getElementById('testimonialForm').setAttribute('data-id', id);
                    document.querySelector('#testimonialForm button[type="submit"]').textContent = 'Update Testimonial';
                    showTestimonialForm();
                }
            } catch (error) {
                console.error('Failed to load testimonial:', error);
                alert('Error loading testimonial data');
            }
        }

        async function deleteTestimonial(id) {
            if (confirm('Are you sure you want to delete this testimonial?')) {
                try {
                    const response = await fetch(`/api/testimonials/${id}`, {
                        method: 'DELETE',
                        headers: {
                            'Authorization': `Bearer ${localStorage.getItem('token')}`,
                            'Accept': 'application/json'
                        }
                    });

                    if (response.ok) {
                        loadTestimonials();
                        alert('Testimonial deleted successfully!');
                    } else {
                        const error = await response.json();
                        alert('Error deleting testimonial: ' + (error.message || 'Unknown error'));
                    }
                } catch (error) {
                    console.error('Failed to delete testimonial:', error);
                    alert('Error deleting testimonial');
                }
            }
        }

        loadTestimonials();
</script>
<script>
    function toggleNav(id){ var el=document.getElementById(id); if(el){ el.classList.toggle('hidden'); } }
</script>
</body>
</html>
