<?php

use App\Http\Controllers\API\BlogPostController;
use App\Http\Controllers\API\TestimonialController;
use App\Http\Controllers\API\HeroSlideController;
use App\Http\Controllers\API\ApartmentController;
use App\Http\Controllers\API\PropertyController;
use App\Http\Controllers\API\CategoryController;
use App\Http\Controllers\API\TagController;
use App\Http\Controllers\API\AnalyticsController;
use App\Http\Controllers\API\SectionSettingsController;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\HousePlanController;
use App\Http\Controllers\API\BookingController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Public routes
Route::post('/login', [AuthController::class, 'login']);
Route::post('/register', [AuthController::class, 'register']);
// AI house plan generation (public endpoint; uses optional API key)
Route::post('/ai/house-plan', [HousePlanController::class, 'generate']);
// Public booking submission
Route::post('/bookings', [BookingController::class, 'store']);

// Public read-only content endpoints used by the marketing site
Route::apiResource('properties', PropertyController::class)->only(['index', 'show']);
Route::apiResource('apartments', ApartmentController::class)->only(['index', 'show']);
Route::apiResource('blogs', BlogPostController::class)->only(['index', 'show']);
Route::apiResource('testimonials', TestimonialController::class)->only(['index', 'show']);
Route::apiResource('hero-slides', HeroSlideController::class)->only(['index', 'show']);
Route::get('/section-settings', [SectionSettingsController::class, 'index']);

// Protected routes
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/user', [AuthController::class, 'user']);

    // Write/update-only endpoints; keep index/show public above
    Route::apiResource('properties', PropertyController::class)->except(['index', 'show']);
    Route::post('properties/import', [PropertyController::class, 'import']);
    Route::apiResource('blogs', BlogPostController::class)->except(['index', 'show']);
    Route::apiResource('testimonials', TestimonialController::class)->except(['index', 'show']);
    Route::apiResource('hero-slides', HeroSlideController::class)->except(['index', 'show']);
    Route::apiResource('apartments', ApartmentController::class)->except(['index', 'show']);

    // Categories & Tags (fully protected)
    Route::apiResource('categories', CategoryController::class);
    Route::apiResource('tags', TagController::class);

    // Analytics (protected)
    Route::get('/analytics', [AnalyticsController::class, 'index']);

    // Section Settings: updates protected; index stays public
    Route::put('/section-settings/{section}', [SectionSettingsController::class, 'update']);

    // Bookings (dashboard)
    Route::get('/bookings', [BookingController::class, 'index']);
    Route::put('/bookings/{id}', [BookingController::class, 'update']);
    Route::get('/bookings/{id}', [BookingController::class, 'show']);
});


