<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hero Slides - NYINIMU Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <div class="bg-white w-64 shadow-lg">
            <div class="p-6">
                <h1 class="text-2xl font-bold text-[#81be01]">NYINIMU</h1>
                <p class="text-sm text-gray-600">Admin Dashboard</p>
            </div>
            <nav class="mt-6">
                <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5a2 2 0 012-2h4a2 2 0 012 2v2H8V5z"></path>
                    </svg>
                    Dashboard
                </a>
                <a href="<?php echo e(route('dashboard.properties')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                    Properties
                </a>
                <div class="px-6">
                    <button type="button" onclick="toggleNav('nav-props-sub')" class="text-xs text-gray-600 hover:text-gray-900">Show options</button>
                    <div id="nav-props-sub" class="ml-6 mt-2 space-y-1 hidden">
                        <a href="<?php echo e(route('dashboard.properties')); ?>#create" class="block text-sm text-gray-700 hover:underline">Add New</a>
                        <a href="<?php echo e(route('dashboard.properties')); ?>#categories" class="block text-sm text-gray-700 hover:underline">Categories</a>
                        <a href="<?php echo e(route('dashboard.properties')); ?>#category-create" class="block text-sm text-gray-700 hover:underline">Create New Category</a>
                    </div>
                </div>
                <a href="<?php echo e(route('dashboard.blogs')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                    </svg>
                    Blog Posts
                </a>
                <div class="px-6">
                    <button type="button" onclick="toggleNav('nav-blogs-sub')" class="text-xs text-gray-600 hover:text-gray-900">Show options</button>
                    <div id="nav-blogs-sub" class="ml-6 mt-2 space-y-1 hidden">
                        <a href="<?php echo e(route('dashboard.blogs')); ?>#create" class="block text-sm text-gray-700 hover:underline">Add New</a>
                        <a href="<?php echo e(route('dashboard.blogs')); ?>#categories" class="block text-sm text-gray-700 hover:underline">Categories</a>
                        <a href="<?php echo e(route('dashboard.blogs')); ?>#category-create" class="block text-sm text-gray-700 hover:underline">Create New Category</a>
                    </div>
                </div>
                <a href="<?php echo e(route('dashboard.testimonials')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                    </svg>
                    Testimonials
                </a>
                <a href="<?php echo e(route('dashboard.hero-slides')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200 bg-blue-50 text-[#81be01] border-r-4 border-blue-600">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    Hero Slides
                </a>
                <a href="<?php echo e(route('dashboard.apartments')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                    </svg>
                    Apartments
                </a>
                <form method="POST" action="<?php echo e(route('logout')); ?>" class="px-6 py-3">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="flex items-center gap-3 w-full text-left text-red-600 hover:text-red-800 transition-colors duration-200">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                        </svg>
                        Logout
                    </button>
                </form>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 p-8">
            <div class="mb-8">
                <h2 class="text-3xl font-bold text-[#81be01]">Manage Hero Slides</h2>
                <p class="text-gray-600 mt-2">View and manage hero slides for the homepage.</p>
            </div>

            <!-- Create Hero Slide Form -->
            <div id="create-hero-slide-form" class="bg-white p-8 rounded-xl shadow-xl mb-8 hidden border border-gray-100">
                <div class="flex items-center gap-3 mb-6">
                    <div class="w-10 h-10 bg-gradient-to-br from-orange-500 to-orange-600 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-2xl font-bold text-[#81be01]">Create New Hero Slide</h3>
                        <p class="text-gray-600">Add stunning homepage banner images</p>
                    </div>
                </div>
                <form id="heroSlideForm" class="space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Title</label>
                            <input type="text" name="title" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Order</label>
                            <input type="number" name="order" min="1" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Background Image</label>
                            <input type="file" name="background_image" accept="image/*" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                            <div class="mt-2">
                                <img id="bg-preview" alt="Background preview" class="hidden w-full h-40 object-cover rounded-md border border-gray-200" />
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Interior Image</label>
                            <input type="file" name="interior_image" accept="image/*" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                            <div class="mt-2">
                                <img id="int-preview" alt="Interior preview" class="hidden w-full h-40 object-cover rounded-md border border-gray-200" />
                            </div>
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Subtitle</label>
                        <input type="text" name="subtitle" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                    </div>
                    <div class="flex items-center">
                        <input type="hidden" name="is_active" value="0">
                        <label class="inline-flex items-center cursor-pointer select-none">
                            <input type="checkbox" name="is_active" value="1" class="sr-only peer" checked>
                            <div class="relative w-11 h-6 bg-gray-200 rounded-full transition-colors peer-focus:outline-none peer-checked:bg-[#81be01]">
                                <span class="absolute top-0.5 left-0.5 h-5 w-5 bg-white rounded-full shadow transition-transform peer-checked:translate-x-5"></span>
                            </div>
                            <span class="ml-2 text-sm text-gray-900">Active Slide</span>
                        </label>
                    </div>
                    <div class="flex justify-end space-x-3 pt-6 border-t border-gray-100">
                        <button type="button" onclick="hideHeroSlideForm()" class="bg-gray-500 text-white px-6 py-3 rounded-lg hover:bg-gray-600 transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg">Cancel</button>
                        <button type="submit" class="bg-gradient-to-r from-orange-500 to-orange-600 text-white px-6 py-3 rounded-lg hover:from-orange-600 hover:to-orange-700 transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg flex items-center gap-2">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            Create Hero Slide
                        </button>
                    </div>
                </form>
            </div>

            <div class="bg-white p-6 rounded-xl shadow-lg">
                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
                    <div>
                        <h3 class="text-2xl font-bold text-[#81be01]">Hero Slides List</h3>
                        <p class="text-gray-600 mt-1">Manage homepage banner slides</p>
                    </div>
                    <button onclick="showHeroSlideForm()" class="bg-gradient-to-r from-orange-500 to-orange-600 text-white px-6 py-3 rounded-lg hover:from-orange-600 hover:to-orange-700 transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-xl flex items-center gap-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Add New Hero Slide
                    </button>
                </div>
                <div id="hero-slides-list" class="overflow-x-auto">
                    <!-- Hero slides will be loaded here -->
                </div>
            </div>
        </div>
    </div>

    <script>
        function showHeroSlideForm() {
            document.getElementById('create-hero-slide-form').classList.remove('hidden');
        }

        function hideHeroSlideForm() {
            document.getElementById('create-hero-slide-form').classList.add('hidden');
            document.getElementById('heroSlideForm').reset();
        }

async function createHeroSlide(formData) {
            try {
                const response = await fetch('/api/hero-slides', {
                    method: 'POST',
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    },
                    body: formData
                });

                if (response.ok) {
                    hideHeroSlideForm();
                    loadHeroSlides();
                    alert('Hero slide created successfully!');
                } else {
                    const error = await response.json();
                    alert('Error creating hero slide: ' + (error.message || 'Unknown error'));
                }
            } catch (error) {
                console.error('Failed to create hero slide:', error);
                alert('Error creating hero slide');
            }
        }

        async function loadHeroSlides() {
            try {
                const response = await fetch('/api/hero-slides', {
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    }
                });
                const data = await response.json();
                const list = document.getElementById('hero-slides-list');
                const slides = (data.data || []).map(s => ({ ...s, __active: !!(s.active ?? s.is_active ?? s['is_active']) }));
                if (slides.length > 0) {
                    list.innerHTML = '<table class="w-full table-auto"><thead><tr><th class="px-4 py-2">Title</th><th class="px-4 py-2">Order</th><th class="px-4 py-2">Active</th><th class="px-4 py-2">Actions</th></tr></thead><tbody>' +
                        slides.map(slide => `<tr>
                            <td class="border px-4 py-2">
                                <div class="flex items-center gap-3">
                                    ${slide.background_image ? `<img src="${slide.background_image}" alt="${slide.title}" class="w-16 h-10 object-cover rounded border" />` : ''}
                                    <span>${slide.title}</span>
                                </div>
                            </td>
                            <td class="border px-4 py-2">${slide.order ?? ''}</td>
                            <td class="border px-4 py-2">${(slide.active ?? slide.is_active) ? 'Yes' : 'No'}</td>
                            <td class="border px-4 py-2">
                                <button onclick="editHeroSlide(${slide.id})" class="bg-[#81be01] text-white px-3 py-1.5 rounded text-sm hover:bg-[#6da001] transition-colors duration-200 mr-2">Edit</button>
                                <button onclick="deleteHeroSlide(${slide.id})" class="bg-red-500 text-white px-3 py-1.5 rounded text-sm hover:bg-red-600 transition-colors duration-200">Delete</button>
                            </td>
                        </tr>`).join('') +
                        '</tbody></table>';
                } else {
                    list.innerHTML = '<p>No hero slides found.</p>';
                }
            } catch (error) {
                console.error('Failed to load hero slides:', error);
                document.getElementById('hero-slides-list').innerHTML = '<p>Error loading hero slides.</p>';
            }
        }

        async function editHeroSlide(id) {
            try {
                const response = await fetch(`/api/hero-slides/${id}`, {
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    }
                });
                const payload = await response.json();
                const slide = payload.data || payload;
                const form = document.getElementById('heroSlideForm');
                form.title.value = slide.title || '';
                form.subtitle.value = slide.subtitle || '';
                form.order.value = slide.order || '';
                form.is_active.checked = !!(slide.active ?? slide.is_active);
                if (form.background_image) { form.background_image.removeAttribute('required'); }
                // Set previews
                const bg = document.getElementById('bg-preview');
                const intr = document.getElementById('int-preview');
                if (bg && slide.background_image) { bg.src = slide.background_image; bg.classList.remove('hidden'); }
                if (intr && slide.interior_image) { intr.src = slide.interior_image; intr.classList.remove('hidden'); }
                form.setAttribute('data-mode', 'edit');
                form.setAttribute('data-id', id);
                document.querySelector('#heroSlideForm button[type="submit"]').textContent = 'Update Hero Slide';
                showHeroSlideForm();
            } catch (err) {
                console.error('Failed to load slide:', err);
                alert('Failed to load slide for editing');
            }
        }

        async function updateHeroSlide(id, formData) {
            try {
                const fd = new FormData();
                fd.append('_method', 'PUT');
                for (const [k, v] of formData.entries()) {
                    // Skip empty file fields (nullable images)
                    if (v instanceof File) {
                        if (!v.name || v.size === 0) continue;
                    }
                    fd.append(k, v);
                }
                const response = await fetch(`/api/hero-slides/${id}`, {
                    method: 'POST',
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    },
                    body: fd
                });
                if (response.ok) {
                    const form = document.getElementById('heroSlideForm');
                    form.removeAttribute('data-mode');
                    form.removeAttribute('data-id');
                    document.querySelector('#heroSlideForm button[type="submit"]').textContent = 'Create Hero Slide';
                    hideHeroSlideForm();
                    loadHeroSlides();
                    alert('Hero slide updated successfully!');
                } else {
                    const error = await response.json();
                    alert('Error updating hero slide: ' + (error.message || 'Unknown error'));
                }
            } catch (err) {
                console.error('Failed to update slide:', err);
                alert('Error updating hero slide');
            }
        }

        async function deleteHeroSlide(id) {
            if (!confirm('Are you sure you want to delete this slide?')) return;
            try {
                const response = await fetch(`/api/hero-slides/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    }
                });
                if (response.ok) {
                    loadHeroSlides();
                    alert('Hero slide deleted successfully!');
                } else {
                    const error = await response.json();
                    alert('Error deleting hero slide: ' + (error.message || 'Unknown error'));
                }
            } catch (err) {
                console.error('Failed to delete slide:', err);
                alert('Error deleting hero slide');
            }
        }

        document.getElementById('heroSlideForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(e.target);
            // Ensure boolean and integer fields are set
            formData.set('is_active', e.target.is_active.checked ? '1' : '0');
            const order = formData.get('order');
            if (order != null && order !== '') {
                formData.set('order', String(parseInt(order, 10)));
            }
            // If no interior image selected, remove field so it passes nullable validation
            const intInput = e.target.interior_image;
            if (!intInput || !intInput.files || intInput.files.length === 0) {
                formData.delete('interior_image');
            }
            const mode = e.target.getAttribute('data-mode');
            const id = e.target.getAttribute('data-id');
            if (mode === 'edit' && id) {
                updateHeroSlide(id, formData);
            } else {
                createHeroSlide(formData);
            }
        });

        // Image preview handlers
        (function(){
            const form = document.getElementById('heroSlideForm');
            if (!form) return;
            const bgInput = form.querySelector('input[name="background_image"]');
            const intInput = form.querySelector('input[name="interior_image"]');
            const setPreview = (input, imgId) => {
                input?.addEventListener('change', (e) => {
                    const file = e.target.files && e.target.files[0];
                    const img = document.getElementById(imgId);
                    if (file && img) {
                        img.src = URL.createObjectURL(file);
                        img.classList.remove('hidden');
                    }
                });
            };
            setPreview(bgInput, 'bg-preview');
            setPreview(intInput, 'int-preview');
        })();

        loadHeroSlides();
    </script>
    <script>
        function toggleNav(id){ var el=document.getElementById(id); if(el){ el.classList.toggle('hidden'); } }
    </script>
</body>
</html>




<?php /**PATH C:\Users\HP\Desktop\Ninimu Site\backend\resources\views/dashboard/hero-slides.blade.php ENDPATH**/ ?>