<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Blog Posts - NYINIMU Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <div class="bg-white w-64 shadow-lg">
            <div class="p-6">
                <h1 class="text-2xl font-bold text-[#81be01]">NYINIMU</h1>
                <p class="text-sm text-gray-600">Admin Dashboard</p>
            </div>
            <nav class="mt-6">
                <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5a2 2 0 012-2h4a2 2 0 012 2v2H8V5z"></path>
                    </svg>
                    Dashboard
                </a>
                <a href="<?php echo e(route('dashboard.properties')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                    Properties
                </a>
                <div class="px-6">
                    <button type="button" onclick="toggleNav('nav-props-sub')" class="text-xs text-gray-600 hover:text-gray-900">Show options</button>
                    <div id="nav-props-sub" class="ml-6 mt-2 space-y-1 hidden">
                        <a href="<?php echo e(route('dashboard.properties')); ?>#create" class="block text-sm text-gray-700 hover:underline">Add New</a>
                        <a href="<?php echo e(route('dashboard.properties')); ?>#categories" class="block text-sm text-gray-700 hover:underline">Categories</a>
                        <a href="<?php echo e(route('dashboard.properties')); ?>#category-create" class="block text-sm text-gray-700 hover:underline">Create New Category</a>
                    </div>
                </div>
                <a href="<?php echo e(route('dashboard.blogs')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200 bg-blue-50 text-[#81be01] border-r-4 border-blue-600">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                    </svg>
                    Blog Posts
                </a>
                <div class="px-6">
                    <button type="button" onclick="toggleNav('nav-blogs-sub')" class="text-xs text-gray-600 hover:text-gray-900">Show options</button>
                    <div id="nav-blogs-sub" class="ml-6 mt-2 space-y-1 hidden">
                        <a href="<?php echo e(route('dashboard.blogs')); ?>#create" class="block text-sm text-gray-700 hover:underline">Add New</a>
                        <a href="<?php echo e(route('dashboard.blogs')); ?>#categories" class="block text-sm text-gray-700 hover:underline">Categories</a>
                        <a href="<?php echo e(route('dashboard.blogs')); ?>#category-create" class="block text-sm text-gray-700 hover:underline">Create New Category</a>
                    </div>
                </div>
                <a href="<?php echo e(route('dashboard.testimonials')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                    </svg>
                    Testimonials
                </a>
                <a href="<?php echo e(route('dashboard.hero-slides')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    Hero Slides
                </a>
                <a href="<?php echo e(route('dashboard.apartments')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                    </svg>
                    Apartments
                </a>
                <a href="#" onclick="showCategories()" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                    </svg>
                    Categories
                </a>
                <form method="POST" action="<?php echo e(route('logout')); ?>" class="px-6 py-3">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="flex items-center gap-3 w-full text-left text-red-600 hover:text-red-800 transition-colors duration-200">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                        </svg>
                        Logout
                    </button>
                </form>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 p-8">
            <!-- Categories Section -->
            <div id="categories-section" class="mb-8 hidden">
                <h2 class="text-3xl font-bold text-[#81be01]">Manage Categories</h2>
                <p class="text-gray-600 mt-2">Create and manage categories for properties and blog posts.</p>

                <!-- Create Category Form -->
                <div class="bg-white p-6 rounded-lg shadow mt-4">
                    <h3 class="text-xl font-semibold text-[#81be01] mb-4">Create New Category</h3>
                    <form id="categoryForm" class="space-y-4">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Name</label>
                                <input type="text" name="name" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Description</label>
                                <input type="text" name="description" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                            </div>
                        </div>
                        <div class="flex justify-end space-x-3">
                            <button type="button" onclick="hideCategories()" class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">Back to Blog Posts</button>
                            <button type="submit" class="bg-[#81be01] text-white px-4 py-2 rounded hover:bg-[#6da001]">Create Category</button>
                        </div>
                    </form>
                </div>

                <!-- Categories List -->
                <div class="bg-white p-6 rounded-lg shadow mt-4">
                    <h3 class="text-xl font-semibold text-[#81be01] mb-4">Categories List</h3>
                    <div id="categories-list">
                        <!-- Categories will be loaded here -->
                    </div>
                </div>
            </div>

            <div id="blogs-section">
                <div class="mb-8">
                    <h2 class="text-3xl font-bold text-[#81be01]">Manage Blog Posts</h2>
                    <p class="text-gray-600 mt-2">View and manage blog posts.</p>
                </div>

            <!-- Create Blog Form -->
            <div id="create-blog-form" class="bg-white p-8 rounded-xl shadow-xl mb-8 hidden border border-gray-100">
                <div class="flex items-center gap-3 mb-6">
                    <div class="w-10 h-10 bg-gradient-to-br from-green-500 to-green-600 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-2xl font-bold text-[#81be01]">Create New Blog Post</h3>
                        <p class="text-gray-600">Write and publish engaging articles</p>
                    </div>
                </div>
                <form id="blogForm" class="space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Title</label>
                            <input type="text" name="title" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Author</label>
                            <input type="text" name="author" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Date</label>
                            <input type="date" name="date" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Image</label>
                            <input type="file" name="image" accept="image/*" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"><div class="mt-2"><img id="blog-image-preview" alt="Image preview" class="hidden w-full h-40 object-cover rounded-md border border-gray-200" /></div>
                        </div>
                    </div>
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700">Excerpt</label>
                            <textarea name="excerpt" rows="2" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"></textarea>
                        </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700">Content</label>
                        <textarea name="content" rows="6" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"></textarea>
                    </div>
                    <div class="flex items-center space-x-4">
                        <div class="flex items-center">
                            <input type="hidden" name="is_featured" value="0">
                            <input type="checkbox" name="is_featured" value="1" class="h-4 w-4 text-[#81be01] focus:ring-blue-500 border-gray-300 rounded">
                            <label class="ml-2 block text-sm text-gray-900">Featured Post</label>
                        </div>
                        <div class="flex items-center">
                            <input type="hidden" name="published" value="0">
                            <input type="checkbox" name="published" value="1" checked class="h-4 w-4 text-[#81be01] focus:ring-blue-500 border-gray-300 rounded">
                            <label class="ml-2 block text-sm text-gray-900">Published</label>
                        </div>
                    </div>
                    <div class="flex justify-end space-x-3 pt-6 border-t border-gray-100">
                        <button type="button" onclick="hideBlogForm()" class="bg-gray-500 text-white px-6 py-3 rounded-lg hover:bg-gray-600 transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg">Cancel</button>
                        <button type="submit" class="bg-gradient-to-r from-green-500 to-green-600 text-white px-6 py-3 rounded-lg hover:from-green-600 hover:to-green-700 transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg flex items-center gap-2">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            Create Blog Post
                        </button>
                    </div>
                </form>
            </div>

            <div class="bg-white p-6 rounded-xl shadow-lg">
                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
                    <div>
                        <h3 class="text-2xl font-bold text-[#81be01]">Blog Posts List</h3>
                        <p class="text-gray-600 mt-1">Manage your blog articles</p>
                    </div>
                    <button onclick="showBlogForm()" class="bg-gradient-to-r from-green-500 to-green-600 text-white px-6 py-3 rounded-lg hover:from-green-600 hover:to-green-700 transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-xl flex items-center gap-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Add New Blog Post
                    </button>
                </div>
                <div id="blogs-list" class="overflow-x-auto">
                    <!-- Blog posts will be loaded here -->
                </div>
            </div>
        </div>
    </div>

    <script>
        function showBlogForm() {
            document.getElementById('create-blog-form').classList.remove('hidden');
        }

        function hideBlogForm() {
            document.getElementById('create-blog-form').classList.add('hidden');
            document.getElementById('blogForm').reset();
            document.getElementById('blogForm').removeAttribute('data-mode');
            document.getElementById('blogForm').removeAttribute('data-id');
            document.querySelector('#blogForm button[type="submit"]').textContent = 'Create Blog Post';
        }

        async function createBlog(formData) {
            try {
                const response = await fetch('/api/blogs', {
                    method: 'POST',
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    },
                    body: formData
                });

                if (response.ok) {
                    hideBlogForm();
                    loadBlogs();
                    alert('Blog post created successfully!');
                } else {
                    const error = await response.json();
                    alert('Error creating blog post: ' + (error.message || 'Unknown error'));
                }
            } catch (error) {
                console.error('Failed to create blog post:', error);
                alert('Error creating blog post');
            }
        }

        async function updateBlog(id, formData) {
            try {
                const response = await fetch(`/api/blogs/${id}`, {
                    method: 'PUT',
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    },
                    body: formData
                });

                if (response.ok) {
                    hideBlogForm();
                    loadBlogs();
                    alert('Blog post updated successfully!');
                } else {
                    const error = await response.json();
                    alert('Error updating blog post: ' + (error.message || 'Unknown error'));
                }
            } catch (error) {
                console.error('Failed to update blog post:', error);
                alert('Error updating blog post');
            }
        }

        async function loadBlogs() {
            try {
                const response = await fetch('/api/blogs', {
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    }
                });
                const data = await response.json();
                const list = document.getElementById('blogs-list');
                if (data.data && data.data.length > 0) {
                    list.innerHTML = '<table class="w-full table-auto"><thead><tr><th class="px-4 py-2">Title</th><th class="px-4 py-2">Author</th><th class="px-4 py-2">Date</th><th class="px-4 py-2">Published</th><th class="px-4 py-2">Actions</th></tr></thead><tbody>' +
                        data.data.map(blog => `<tr>
                            <td class="border px-4 py-2">
                                <div class="flex items-center gap-3">
                                    ${blog.image ? `<img src="${blog.image}" alt="${blog.title}" class="w-16 h-10 object-cover rounded border" />` : ''}
                                    <span>${blog.title}</span>
                                </div>
                            </td>
                            <td class="border px-4 py-2">${blog.author}</td>
                            <td class="border px-4 py-2">${blog.date}</td>
                            <td class="border px-4 py-2">${blog.published ? 'Yes' : 'No'}</td>
                            <td class="border px-4 py-2">
                                <button onclick="editBlog(${blog.id})" class="bg-[#81be01] text-white px-3 py-1.5 rounded text-sm hover:bg-[#6da001] transition-colors duration-200 mr-2">Edit</button>
                                <button onclick="deleteBlog(${blog.id})" class="bg-red-500 text-white px-3 py-1.5 rounded text-sm hover:bg-red-600 transition-colors duration-200">Delete</button>
                            </td>
                        </tr>`).join('') +
                        '</tbody></table>';
                } else {
                    list.innerHTML = '<p>No blog posts found.</p>';
                }
            } catch (error) {
                console.error('Failed to load blogs:', error);
                document.getElementById('blogs-list').innerHTML = '<p>Error loading blog posts.</p>';
            }
        }

        function showCategories() {
            document.getElementById('blogs-section').classList.add('hidden');
            document.getElementById('categories-section').classList.remove('hidden');
            loadCategories();
        }

        function hideCategories() {
            document.getElementById('categories-section').classList.add('hidden');
            document.getElementById('blogs-section').classList.remove('hidden');
        }

        async function createCategory(formData) {
            try {
                const response = await fetch('/api/categories', {
                    method: 'POST',
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json',
                        // Sending FormData; let browser set multipart boundary
                    },
                    body: formData
                });

                if (response.ok) {
                    document.getElementById('categoryForm').reset();
                    loadCategories();
                    alert('Category created successfully!');
                } else {
                    const error = await response.json();
                    alert('Error creating category: ' + (error.message || 'Unknown error'));
                }
            } catch (error) {
                console.error('Failed to create category:', error);
                alert('Error creating category');
            }
        }

        async function loadCategories() {
            try {
                const response = await fetch('/api/categories', {
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    }
                });
                const data = await response.json();
                const list = document.getElementById('categories-list');
                if (data.data && data.data.length > 0) {
                    list.innerHTML = '<table class="w-full table-auto"><thead><tr><th class="px-4 py-2">Name</th><th class="px-4 py-2">Description</th><th class="px-4 py-2">Count</th><th class="px-4 py-2">Actions</th></tr></thead><tbody>' +
                        data.data.map(category => `<tr><td class="border px-4 py-2">${category.name}</td><td class="border px-4 py-2">${category.description || ''}</td><td class="border px-4 py-2">${category.count || 0}</td><td class="border px-4 py-2"><button onclick="editBlog(${blog.id})" class="text-[#81be01] hover:text-blue-800 mr-2 transition-colors duration-200">Edit</button> <button onclick="deleteBlog(${blog.id})" class="text-red-600 hover:text-red-800 transition-colors duration-200">Delete</button></td></tr>`).join('') +
                        '</tbody></table>';
                } else {
                    list.innerHTML = '<p>No categories found.</p>';
                }
            } catch (error) {
                console.error('Failed to load categories:', error);
                document.getElementById('categories-list').innerHTML = '<p>Error loading categories.</p>';
            }
        }

        document.getElementById('blogForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(e.target);

            const mode = e.target.getAttribute('data-mode');
            const id = e.target.getAttribute('data-id');

            if (mode === 'edit' && id) {
                updateBlog(id, formData);
            } else {
                createBlog(formData);
            }
        });

        document.getElementById('categoryForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(e.target);
            const data = Object.fromEntries(formData);
            createCategory(data);
        });

        async function editBlog(id) {
            try {
                const response = await fetch(`/api/blogs/${id}`, {
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    }
                });
                const data = await response.json();
                if (data.success && data.data) {
                    const blog = data.data;
                    // Populate form with existing data
                    document.getElementById('blogForm').title.value = blog.title;
                    document.getElementById('blogForm').author.value = blog.author;
                    document.getElementById('blogForm').date.value = blog.date;
                    document.getElementById('blogForm').excerpt.value = blog.excerpt || '';
                    document.getElementById('blogForm').content.value = blog.content;
                    document.getElementById('blogForm').is_featured.checked = blog.is_featured;
                    document.getElementById('blogForm').published.checked = blog.published;
                    // Change form to update mode
                    document.getElementById('blogForm').setAttribute('data-mode', 'edit');
                    document.getElementById('blogForm').setAttribute('data-id', id);
                    document.querySelector('#blogForm button[type="submit"]').textContent = 'Update Blog Post';
                    showBlogForm();
                }
            } catch (error) {
                console.error('Failed to load blog:', error);
                alert('Error loading blog data');
            }
        }

        async function deleteBlog(id) {
            if (confirm('Are you sure you want to delete this blog post?')) {
                try {
                    const response = await fetch(`/api/blogs/${id}`, {
                        method: 'DELETE',
                        headers: {
                            'Authorization': `Bearer ${localStorage.getItem('token')}`,
                            'Accept': 'application/json'
                        }
                    });

                    if (response.ok) {
                        loadBlogs();
                        alert('Blog post deleted successfully!');
                    } else {
                        const error = await response.json();
                        alert('Error deleting blog post: ' + (error.message || 'Unknown error'));
                    }
                } catch (error) {
                    console.error('Failed to delete blog post:', error);
                    alert('Error deleting blog post');
                }
            }
        }

        loadBlogs();
        // Blog image preview
        (function(){
            const form = document.getElementById('blogForm');
            if (!form) return;
            const imgInput = form.querySelector('input[name="image"]');
            imgInput?.addEventListener('change', (e) => {
                const file = e.target.files && e.target.files[0];
                const img = document.getElementById('blog-image-preview');
                if (file && img) { img.src = URL.createObjectURL(file); img.classList.remove('hidden'); }
            });
        })();
    </script>
    <script>
        function toggleNav(id){
            var el = document.getElementById(id);
            if(!el) return;
            el.classList.toggle('hidden');
        }
        // Deep-link handlers from sidebar anchors
        document.addEventListener('DOMContentLoaded', function(){
            var h = window.location.hash;
            if (h === '#create' && typeof showBlogForm === 'function') {
                showBlogForm();
            }
            if ((h === '#categories' || h === '#category-create') && typeof showCategories === 'function') {
                showCategories();
                if (h === '#category-create') {
                    var f = document.getElementById('categoryForm');
                    if (f && typeof f.scrollIntoView === 'function') { f.scrollIntoView({behavior:'smooth'}); }
                }
            }
        });
    </script>
</body>
</html>


<?php /**PATH C:\Users\HP\Downloads\nyinimu-3-main-fixed-v2\backend\resources\views/dashboard/blogs.blade.php ENDPATH**/ ?>