<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>NYINIMU Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <div class="bg-white w-64 shadow-lg">
            <div class="p-6">
                <h1 class="text-2xl font-bold text-[#81be01]">NYINIMU</h1>
                <p class="text-sm text-gray-600">Admin Dashboard</p>
            </div>
            <nav class="mt-6">
                <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200 <?php echo e(request()->routeIs('dashboard') ? 'bg-[#81be01] bg-opacity-10 text-[#81be01] border-r-4 border-[#81be01]' : ''); ?>">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5a2 2 0 012-2h4a2 2 0 012 2v2H8V5z"></path>
                    </svg>
                    Dashboard
                </a>
                <a href="<?php echo e(route('dashboard.properties')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200 <?php echo e(request()->routeIs('dashboard.properties') ? 'bg-[#81be01] bg-opacity-10 text-[#81be01] border-r-4 border-[#81be01]' : ''); ?>">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                    Properties
                </a>
                <div class="px-6">
                    <button type="button" onclick="toggleNav('nav-props-sub')" class="text-xs text-gray-600 hover:text-gray-900">Show options</button>
                    <div id="nav-props-sub" class="ml-6 mt-2 space-y-1 hidden">
                        <a href="<?php echo e(route('dashboard.properties')); ?>#create" class="block text-sm text-gray-700 hover:underline">Add New</a>
                        <a href="<?php echo e(route('dashboard.properties')); ?>#categories" class="block text-sm text-gray-700 hover:underline">Categories</a>
                        <a href="<?php echo e(route('dashboard.properties')); ?>#category-create" class="block text-sm text-gray-700 hover:underline">Create New Category</a>
                    </div>
                </div>
                <a href="<?php echo e(route('dashboard.blogs')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200 <?php echo e(request()->routeIs('dashboard.blogs') ? 'bg-[#81be01] bg-opacity-10 text-[#81be01] border-r-4 border-[#81be01]' : ''); ?>">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                    </svg>
                    Blog Posts
                </a>
                <div class="px-6">
                    <button type="button" onclick="toggleNav('nav-blogs-sub')" class="text-xs text-gray-600 hover:text-gray-900">Show options</button>
                    <div id="nav-blogs-sub" class="ml-6 mt-2 space-y-1 hidden">
                        <a href="<?php echo e(route('dashboard.blogs')); ?>#create" class="block text-sm text-gray-700 hover:underline">Add New</a>
                        <a href="<?php echo e(route('dashboard.blogs')); ?>#categories" class="block text-sm text-gray-700 hover:underline">Categories</a>
                        <a href="<?php echo e(route('dashboard.blogs')); ?>#category-create" class="block text-sm text-gray-700 hover:underline">Create New Category</a>
                    </div>
                </div>
                <a href="<?php echo e(route('dashboard.testimonials')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200 <?php echo e(request()->routeIs('dashboard.testimonials') ? 'bg-[#81be01] bg-opacity-10 text-[#81be01] border-r-4 border-[#81be01]' : ''); ?>">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                    </svg>
                    Testimonials
                </a>
                <a href="<?php echo e(route('dashboard.hero-slides')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200 <?php echo e(request()->routeIs('dashboard.hero-slides') ? 'bg-[#81be01] bg-opacity-10 text-[#81be01] border-r-4 border-[#81be01]' : ''); ?>">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    Hero Slides
                </a>
                <a href="<?php echo e(route('dashboard.apartments')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200 <?php echo e(request()->routeIs('dashboard.apartments') ? 'bg-[#81be01] bg-opacity-10 text-[#81be01] border-r-4 border-[#81be01]' : ''); ?>">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                    </svg>
                    Apartments
                </a>
                <a href="<?php echo e(route('dashboard.bookings')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200 <?php echo e(request()->routeIs('dashboard.bookings') ? 'bg-[#81be01] bg-opacity-10 text-[#81be01] border-r-4 border-[#81be01]' : ''); ?>">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    Bookings
                </a>
                <a href="#" onclick="showCategories()" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                    </svg>
                    Categories
                </a>
                <a href="http://localhost:3000" target="_blank" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                    </svg>
                    View Website
                </a>
                <form method="POST" action="<?php echo e(route('logout')); ?>" class="px-6 py-3">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="flex items-center gap-3 w-full text-left text-red-600 hover:text-red-800 transition-colors duration-200">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                        </svg>
                        Logout
                    </button>
                </form>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 p-8">
            <div class="mb-8">
                <h2 class="text-3xl font-bold text-[#81be01]">Dashboard Overview</h2>
                <p class="text-gray-600 mt-2">Welcome back, <?php echo e(auth()->user()->name); ?>!</p>
            </div>

            <!-- Schedule Your Visit Message -->
            <div class="mb-8">
                <div class="bg-[#81be01] text-white rounded-lg shadow flex flex-col md:flex-row md:items-center md:justify-between p-4">
                    <div class="flex items-center gap-3">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2v-5H3v5a2 2 0 002 2z"/>
                        </svg>
                        <div class="text-sm md:text-base">
                            <span class="font-semibold">Schedule Your Visit</span>
                            <span class="opacity-90"> — Invite clients to book a site visit easily.</span>
                        </div>
                    </div>
                    <a href="http://localhost:3000/request-viewing" target="_blank" rel="noopener noreferrer"
                       class="mt-3 md:mt-0 inline-flex items-center bg-white text-[#81be01] px-4 py-2 rounded-md font-medium hover:bg-white/95">
                        Open Booking Page
                    </a>
                </div>
            </div>

            <!-- Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                <div class="bg-white p-6 rounded-lg shadow">
                    <h3 class="text-lg font-semibold text-[#81be01]">Properties</h3>
                    <p class="text-3xl font-bold text-[#81be01]" id="properties-count">0</p>
                </div>
                <div class="bg-white p-6 rounded-lg shadow">
                    <h3 class="text-lg font-semibold text-[#81be01]">Blog Posts</h3>
                    <p class="text-3xl font-bold text-green-600" id="blogs-count">0</p>
                </div>
                <div class="bg-white p-6 rounded-lg shadow">
                    <h3 class="text-lg font-semibold text-[#81be01]">Testimonials</h3>
                    <p class="text-3xl font-bold text-purple-600" id="testimonials-count">0</p>
                </div>
                <div class="bg-white p-6 rounded-lg shadow">
                    <h3 class="text-lg font-semibold text-[#81be01]">Hero Slides</h3>
                    <p class="text-3xl font-bold text-orange-600" id="hero-slides-count">0</p>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white p-6 rounded-lg shadow">
                <h3 class="text-xl font-semibold text-[#81be01] mb-6">Quick Actions</h3>
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-5 gap-6">
                    <a href="<?php echo e(route('dashboard.properties')); ?>" class="group relative overflow-hidden bg-gradient-to-br from-blue-500 to-blue-600 text-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                        <div class="absolute inset-0 bg-gradient-to-br from-blue-400 to-blue-500 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                        <div class="relative z-10">
                            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-lg flex items-center justify-center mb-3">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                </svg>
                            </div>
                            <h4 class="font-semibold text-lg mb-1">Properties</h4>
                            <p class="text-blue-100 text-sm">Manage property listings</p>
                        </div>
                    </a>

                    <a href="<?php echo e(route('dashboard.blogs')); ?>" class="group relative overflow-hidden bg-gradient-to-br from-green-500 to-green-600 text-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                        <div class="absolute inset-0 bg-gradient-to-br from-green-400 to-green-500 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                        <div class="relative z-10">
                            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-lg flex items-center justify-center mb-3">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                </svg>
                            </div>
                            <h4 class="font-semibold text-lg mb-1">Blog Posts</h4>
                            <p class="text-green-100 text-sm">Create and edit articles</p>
                        </div>
                    </a>

                    <a href="<?php echo e(route('dashboard.testimonials')); ?>" class="group relative overflow-hidden bg-gradient-to-br from-purple-500 to-purple-600 text-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                        <div class="absolute inset-0 bg-gradient-to-br from-purple-400 to-purple-500 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                        <div class="relative z-10">
                            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-lg flex items-center justify-center mb-3">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                                </svg>
                            </div>
                            <h4 class="font-semibold text-lg mb-1">Testimonials</h4>
                            <p class="text-purple-100 text-sm">Manage customer reviews</p>
                        </div>
                    </a>

                    <a href="<?php echo e(route('dashboard.hero-slides')); ?>" class="group relative overflow-hidden bg-gradient-to-br from-orange-500 to-orange-600 text-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                        <div class="absolute inset-0 bg-gradient-to-br from-orange-400 to-orange-500 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                        <div class="relative z-10">
                            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-lg flex items-center justify-center mb-3">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                </svg>
                            </div>
                            <h4 class="font-semibold text-lg mb-1">Hero Slides</h4>
                            <p class="text-orange-100 text-sm">Control homepage banners</p>
                        </div>
                    </a>

                    <a href="<?php echo e(route('dashboard.apartments')); ?>" class="group relative overflow-hidden bg-gradient-to-br from-red-500 to-red-600 text-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                        <div class="absolute inset-0 bg-gradient-to-br from-red-400 to-red-500 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                        <div class="relative z-10">
                            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-lg flex items-center justify-center mb-3">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                                </svg>
                            </div>
                            <h4 class="font-semibold text-lg mb-1">Apartments</h4>
                            <p class="text-red-100 text-sm">Manage apartment listings</p>
                        </div>
                    </a>

                    <a href="<?php echo e(route('dashboard.bookings')); ?>" class="group relative overflow-hidden bg-gradient-to-br from-teal-500 to-teal-600 text-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                        <div class="absolute inset-0 bg-gradient-to-br from-teal-400 to-teal-500 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                        <div class="relative z-10">
                            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-lg flex items-center justify-center mb-3">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                </svg>
                            </div>
                            <h4 class="font-semibold text-lg mb-1">Bookings</h4>
                            <p class="text-teal-100 text-sm">Manage booking requests</p>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Load analytics data
        async function loadAnalytics() {
            try {
                const response = await fetch('/api/analytics', {
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    }
                });
                const data = await response.json();

                document.getElementById('properties-count').textContent = data.properties.total;
                document.getElementById('blogs-count').textContent = data.blogPosts.total;
                document.getElementById('testimonials-count').textContent = data.testimonials.total;
                document.getElementById('hero-slides-count').textContent = data.heroSlides ? data.heroSlides.total : 0;
            } catch (error) {
                console.error('Failed to load analytics:', error);
            }
        }

        loadAnalytics();
    </script>
    <script>
        function toggleNav(id){ var el=document.getElementById(id); if(el){ el.classList.toggle('hidden'); } }
    </script>
</body>
</html>
<?php /**PATH C:\Users\HP\Desktop\Ninimu Site\backend\resources\views/dashboard/index.blade.php ENDPATH**/ ?>