<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bookings - NYINIMU Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <div class="bg-white w-64 shadow-lg">
            <div class="p-6">
                <h1 class="text-2xl font-bold text-[#81be01]">NYINIMU</h1>
                <p class="text-sm text-gray-600">Admin Dashboard</p>
            </div>
            <nav class="mt-6">
                <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5a2 2 0 012-2h4a2 2 0 012 2v2H8V5z"></path>
                    </svg>
                    Dashboard
                </a>
                <a href="<?php echo e(route('dashboard.properties')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                    Properties
                </a>
                <div class="px-6">
                    <button type="button" onclick="toggleNav('nav-props-sub')" class="text-xs text-gray-600 hover:text-gray-900">Show options</button>
                    <div id="nav-props-sub" class="ml-6 mt-2 space-y-1 hidden">
                        <a href="<?php echo e(route('dashboard.properties')); ?>#create" class="block text-sm text-gray-700 hover:underline">Add New</a>
                        <a href="<?php echo e(route('dashboard.properties')); ?>#categories" class="block text-sm text-gray-700 hover:underline">Categories</a>
                        <a href="<?php echo e(route('dashboard.properties')); ?>#category-create" class="block text-sm text-gray-700 hover:underline">Create New Category</a>
                    </div>
                </div>
                <a href="<?php echo e(route('dashboard.blogs')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                    </svg>
                    Blog Posts
                </a>
                <div class="px-6">
                    <button type="button" onclick="toggleNav('nav-blogs-sub')" class="text-xs text-gray-600 hover:text-gray-900">Show options</button>
                    <div id="nav-blogs-sub" class="ml-6 mt-2 space-y-1 hidden">
                        <a href="<?php echo e(route('dashboard.blogs')); ?>#create" class="block text-sm text-gray-700 hover:underline">Add New</a>
                        <a href="<?php echo e(route('dashboard.blogs')); ?>#categories" class="block text-sm text-gray-700 hover:underline">Categories</a>
                        <a href="<?php echo e(route('dashboard.blogs')); ?>#category-create" class="block text-sm text-gray-700 hover:underline">Create New Category</a>
                    </div>
                </div>
                <a href="<?php echo e(route('dashboard.testimonials')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                    </svg>
                    Testimonials
                </a>
                <a href="<?php echo e(route('dashboard.hero-slides')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    Hero Slides
                </a>
                <a href="<?php echo e(route('dashboard.apartments')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                    </svg>
                    Apartments
                </a>
                <a href="<?php echo e(route('dashboard.bookings')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200 bg-blue-50 text-[#81be01] border-r-4 border-blue-600">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    Bookings
                </a>
                <a href="<?php echo e(route('dashboard.bookings')); ?>" class="flex items-center gap-3 px-6 py-3 text-gray-700 hover:bg-gray-100 transition-all duration-200 bg-blue-50 text-[#81be01] border-r-4 border-blue-600">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    Bookings
                </a>
                <form method="POST" action="<?php echo e(route('logout')); ?>" class="px-6 py-3">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="flex items-center gap-3 w-full text-left text-red-600 hover:text-red-800 transition-colors duration-200">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                        </svg>
                        Logout
                    </button>
                </form>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 p-8">
            <div class="mb-8">
                <h2 class="text-3xl font-bold text-[#81be01]">Manage Bookings</h2>
                <p class="text-gray-600 mt-2">View and manage property booking requests.</p>
            </div>

            <div class="bg-white p-6 rounded-xl shadow-lg">
                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
                    <div>
                        <h3 class="text-2xl font-bold text-[#81be01]">Bookings List</h3>
                        <p class="text-gray-600 mt-1">Manage customer booking requests</p>
                    </div>
                </div>
                <div id="bookings-list" class="overflow-x-auto">
                    <!-- Bookings will be loaded here -->
                </div>
            </div>
        </div>
    </div>

    <script>
        async function loadBookings() {
            try {
                const response = await fetch('/api/bookings', {
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json'
                    }
                });
                const data = await response.json();
                const list = document.getElementById('bookings-list');
                if (data.data && data.data.length > 0) {
                    list.innerHTML = '<table class="w-full table-auto"><thead><tr><th class="px-4 py-2">Customer</th><th class="px-4 py-2">Property</th><th class="px-4 py-2">Check-in</th><th class="px-4 py-2">Check-out</th><th class="px-4 py-2">Status</th><th class="px-4 py-2">Actions</th></tr></thead><tbody>' +
                        data.data.map(booking => `<tr>
                            <td class="border px-4 py-2">
                                <div>
                                    <div class="font-medium">${booking.customer_name}</div>
                                    <div class="text-sm text-gray-500">${booking.customer_email}</div>
                                    <div class="text-sm text-gray-500">${booking.customer_phone}</div>
                                </div>
                            </td>
                            <td class="border px-4 py-2">${booking.property?.title || 'N/A'}</td>
                            <td class="border px-4 py-2">${booking.check_in_date}</td>
                            <td class="border px-4 py-2">${booking.check_out_date}</td>
                            <td class="border px-4 py-2">
                                <span class="px-2 py-1 rounded-full text-xs font-medium ${getStatusColor(booking.status)}">
                                    ${booking.status}
                                </span>
                            </td>
                            <td class="border px-4 py-2">
                                <button onclick="updateBookingStatus(${booking.id}, 'confirmed')" class="bg-[#81be01] text-white px-3 py-1.5 rounded text-sm hover:bg-[#6da001] transition-colors duration-200 mr-2">Confirm</button>
                                <button onclick="updateBookingStatus(${booking.id}, 'cancelled')" class="bg-red-500 text-white px-3 py-1.5 rounded text-sm hover:bg-red-600 transition-colors duration-200">Cancel</button>
                            </td>
                        </tr>`).join('') +
                        '</tbody></table>';
                } else {
                    list.innerHTML = '<div class="text-center py-12"><div class="text-gray-500 text-lg">No bookings found</div><p class="text-gray-400 mt-2">Booking requests will appear here when customers make reservations.</p></div>';
                }
            } catch (error) {
                console.error('Failed to load bookings:', error);
                document.getElementById('bookings-list').innerHTML = '<p class="text-red-500 p-4">Error loading bookings. Please try again.</p>';
            }
        }

        function getStatusColor(status) {
            switch (status) {
                case 'pending': return 'bg-yellow-100 text-yellow-800';
                case 'confirmed': return 'bg-green-100 text-green-800';
                case 'cancelled': return 'bg-red-100 text-red-800';
                case 'completed': return 'bg-blue-100 text-blue-800';
                default: return 'bg-gray-100 text-gray-800';
            }
        }

        async function updateBookingStatus(id, status) {
            if (!confirm(`Are you sure you want to ${status} this booking?`)) return;

            try {
                const response = await fetch(`/api/bookings/${id}`, {
                    method: 'PUT',
                    headers: {
                        'Authorization': `Bearer ${localStorage.getItem('token')}`,
                        'Accept': 'application/json',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ status })
                });

                if (response.ok) {
                    loadBookings();
                    alert(`Booking ${status} successfully!`);
                } else {
                    const error = await response.json();
                    alert('Error updating booking: ' + (error.message || 'Unknown error'));
                }
            } catch (error) {
                console.error('Failed to update booking:', error);
                alert('Error updating booking');
            }
        }

        loadBookings();
    </script>
    <script>
        function toggleNav(id){ var el=document.getElementById(id); if(el){ el.classList.toggle('hidden'); } }
    </script>
</body>
</html>
<?php /**PATH C:\Users\HP\Downloads\nyinimu-3-main-fixed-v2\backend\resources\views/dashboard/bookings.blade.php ENDPATH**/ ?>